/*
 * Copyright 2024 S. V. Nickolas.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF, OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef   INCLUDE_H_CUA
#define   INCLUDE_H_CUA

#include "types.h"

extern int must_reset;

void      putchattr     (uint8_t c, uint8_t a, uint8_t x, uint8_t y);
void      putsattr      (char *s, uint8_t a, uint8_t x, uint8_t y);
void      box           (uint8_t a, 
                         uint8_t x1, uint8_t y1, uint8_t x2, uint8_t y2);
void      msgbox        (char *s, char *title);
int32_t   inputbox_int  (char *s, char *title, uint16_t initial);
char     *inputbox_vol  (char *s, char *title);
void      reboot        (void);
void      initty        (void);
void      deinitty      (void);

#endif /* INCLUDE_H_CUA */
